package com.swvoyages.reservation;

import java.util.Random;

/*
* La classe <code>Reservation</code> gre les informations 
* d'une rservation prise en charge par le systme de rservation 
* de la centrale de rservation.
*
* @version  1.0
*/
public class Reservation {
	
	private final static Random idGenerator = new Random();

	private int id = 0;

	private int passengers = 0;
	private String from = "";
	private String to = "";
	private boolean roundTrip = false;
	private int departureDay = 0;
	private int departureMonth = 0;
	private int departureYear = 0;
	private int arrivalDay = 0;
	private int arrivalMonth = 0;
	private int arrivalYear = 0;

	private int remoteAirReservationId = 0;
	private int remoteCarReservationId = 0;
	private int remoteHotelReservationId = 0;
	
	private AirAvailability[] airAvailabilities = new AirAvailability[0];
	private CarAvailability[] carAvailabilities = new CarAvailability[0];
	private HotelAvailability[] hotelAvailabilities = new HotelAvailability[0];

	/*
	* Le constructeur de rservation.
	*/
	public Reservation() {
		getId();
	}

	/*
	* Renvoie l'identifiant de la rservation.
	*/
	public synchronized int getId() {
		if (id == 0) {
			id = idGenerator.nextInt();
		}
		return id;
	}

	/*
	* Renvoie l'identifiant de la rservation
	* de la centrale de rservation arienne.
	*/
	public int getRemoteAirReservationId() {
		return remoteAirReservationId;
	}

	/*
	* Affecte l'identifiant de la rservation
	* de la centrale de rservation arienne.
	*
	* @param		remoteAirReservationId l'identifiant 
	*				de la rservation de la centrale de
	* 				rservation arienne
	*/
	public void setRemoteAirReservationId(int remoteAirReservationId) {
		this.remoteAirReservationId = remoteAirReservationId;
	}

	/*
	* Renvoie l'identifiant de la rservation
	* de la centrale de rservation automobile.
	*/
	public int getRemoteCarReservationId() {
		return remoteCarReservationId;
	}

	/*
	* Affecte l'identifiant de la rservation
	* de la centrale de rservation automobile.
	*
	* @param		remoteCarReservationId l'identifiant 
	*				de la rservation de la centrale de
	* 				rservation automobile
	*/
	public void setRemoteCarReservationId(int remoteCarReservationId) {
		this.remoteCarReservationId = remoteCarReservationId;
	}

	/*
	* Renvoie l'identifiant de la rservation
	* de la centrale de rservation htelire.
	*/
	public int getRemoteHotelReservationId() {
		return remoteHotelReservationId;
	}

	/*
	* Affecte l'identifiant de la rservation
	* de la centrale de rservation htelire.
	*
	* @param		remoteHotelReservationId l'identifiant 
	*				de la rservation de la centrale de
	* 				rservation htelire
	*/
	public void setRemoteHotelReservationId(int remoteHotelReservationId) {
		this.remoteHotelReservationId = remoteHotelReservationId;
	}

	/*
	* Renvoie l'identifiant de la disponibilit de la 
	* centrale de rservation arienne associe  la 
	* disponibilit locale dont l'identifiant est pass
	* en paramtre.
	*/
	public int getRemoteAirAvailabilityId(int availabilityId) 
		throws ReservationException {

		AirAvailability[] availabilities = getAirAvailabilities();
		for(int i=0; i<availabilities.length; i++) {
			AirAvailability availability = availabilities[i];
			if (availability.getId()==availabilityId) {
				return availability.getRemoteId();
			}
		}
		throw new ReservationException("disponibilit du partenaire non trouve");
	}

	/*
	* Renvoie l'identifiant de la disponibilit de la 
	* centrale de rservation automobile associe  la 
	* disponibilit locale dont l'identifiant est pass
	* en paramtre.
	*/
	public int getRemoteCarAvailabilityId(int availabilityId) 
		throws ReservationException {

		CarAvailability[] availabilities = getCarAvailabilities();
		for(int i=0; i<availabilities.length; i++) {
			CarAvailability availability = availabilities[i];
			if (availability.getId()==availabilityId) {
				return availability.getRemoteId();
			}
		}
		throw new ReservationException("disponibilit du partenaire non trouve");
	}

	/*
	* Renvoie l'identifiant de la disponibilit de la 
	* centrale de rservation htelire associe  la 
	* disponibilit locale dont l'identifiant est pass
	* en paramtre.
	*/
	public int getRemoteHotelAvailabilityId(int availabilityId) 
		throws ReservationException {

		HotelAvailability[] availabilities = getHotelAvailabilities();
		for(int i=0; i<availabilities.length; i++) {
			HotelAvailability availability = availabilities[i];
			if (availability.getId()==availabilityId) {
				return availability.getRemoteId();
			}
		}
		throw new ReservationException("disponibilit du partenaire non trouve");
	}

	/*
	* Renvoie les disponibilits de la centrale de
	* rservation arienne associe  cette rservation.
	*/
	public AirAvailability[] getAirAvailabilities() {
		return airAvailabilities;
	}

	/*
	* Affecte les disponibilits de la centrale de
	* rservation arienne associe  cette rservation.
	*
	* @param		airAvailabilities les disponibilits
	*				de la centrale de rservation arienne
	*/
	public void setAirAvailabilities(AirAvailability[] airAvailabilities) {
		this.airAvailabilities = airAvailabilities;
	}

	/*
	* Renvoie les disponibilits de la centrale de
	* rservation automobile associe  cette rservation.
	*/
	public CarAvailability[] getCarAvailabilities() {
		return carAvailabilities;
	}

	/*
	* Affecte les disponibilits de la centrale de
	* rservation automobile associe  cette rservation.
	*
	* @param		carAvailabilities les disponibilits
	*				de la centrale de rservation automobile
	*/
	public void setCarAvailabilities(CarAvailability[] carAvailabilities) {
		this.carAvailabilities = carAvailabilities;
	}

	/*
	* Renvoie les disponibilits de la centrale de
	* rservation htelire associe  cette rservation.
	*/
	public HotelAvailability[] getHotelAvailabilities() {
		return hotelAvailabilities;
	}

	/*
	* Affecte les disponibilits de la centrale de
	* rservation htelire associe  cette rservation.
	*
	* @param		hotelAvailabilities les disponibilits
	*				de la centrale de rservation htelire
	*/
	public void setHotelAvailabilities(HotelAvailability[] hotelAvailabilities) {
		this.hotelAvailabilities = hotelAvailabilities;
	}

	/*
	* Renvoie le nombre de voyageurs.
	*
	* @return		int le nombre de voyageurs
	*/
	public int getPassengers() {
		return this.passengers;
	}

	/*
	* Affecte le nombre de voyageurs.
	*
	* @param		passengers le nombre de voyageurs
	*/
	public void setPassengers(int passengers) {
		this.passengers = passengers;
	}

	/*
	* Renvoie la localit de dpart.
	*
	* @return		String la localit de dpart
	*/
	public String getFrom() {
		return this.from;
	}

	/*
	* Affecte la localit de dpart.
	*
	* @param		from la localit de dpart
	*/
	public void setFrom(String from) {
		this.from = from;
	}

	/*
	* Renvoie la localit d'arrive.
	*
	* @return		String la localit d'arrive
	*/
	public String getTo() {
		return this.to;
	}

	/*
	* Affecte la localit d'arrive.
	*
	* @param		from la localit d'arrive
	*/
	public void setTo(String to) {
		this.to = to;
	}

	/*
	* Renvoie le voyage.
	*
	* @return		boolean le voyage
	*/
	public boolean getRoundTrip() {
		return this.roundTrip;
	}

	/*
	* Affecte le voyage.
	*
	* @param		roundTrip le voyage
	*/
	public void setRoundTrip(boolean roundTrip) {
		this.roundTrip = roundTrip;
	}

	/*
	* Renvoie le jour de dpart.
	*
	* @return		int le jour de dpart
	*/
	public int getDepartureDay() {
		return this.departureDay;
	}

	/*
	* Affecte le jour de dpart.
	*
	* @param		departureDay le jour de dpart
	*/
	public void setDepartureDay(int departureDay) {
		this.departureDay = departureDay;
	}

	/*
	* Renvoie le mois de dpart.
	*
	* @return		int le mois de dpart
	*/
	public int getDepartureMonth() {
		return this.departureMonth;
	}

	/*
	* Affecte le mois de dpart.
	*
	* @param		departureMonth le mois de dpart
	*/
	public void setDepartureMonth(int departureMonth) {
		this.departureMonth = departureMonth;
	}

	/*
	* Renvoie l'anne de dpart.
	*
	* @return		int l'anne de dpart
	*/
	public int getDepartureYear() {
		return this.departureYear;
	}

	/*
	* Affecte l'anne de dpart.
	*
	* @param		departureYear l'anne de dpart
	*/
	public void setDepartureYear(int departureYear) {
		this.departureYear = departureYear;
	}

	/*
	* Renvoie le jour de retour.
	*
	* @return		int le jour de retour
	*/
	public int getArrivalDay() {
		return this.arrivalDay;
	}

	/*
	* Affecte le jour de retour.
	*
	* @param		arrivalDay le jour de retour
	*/
	public void setArrivalDay(int arrivalDay) {
		this.arrivalDay = arrivalDay;
	}

	/*
	* Renvoie le mois de retour.
	*
	* @return		int le mois de retour
	*/
	public int getArrivalMonth() {
		return this.arrivalMonth;
	}

	/*
	* Affecte le mois de retour.
	*
	* @param		arrivalMonth le mois de retour
	*/
	public void setArrivalMonth(int arrivalMonth) {
		this.arrivalMonth = arrivalMonth;
	}

	/*
	* Renvoie l'anne de retour.
	*
	* @return		int l'anne de retour
	*/
	public int getArrivalYear() {
		return this.arrivalYear;
	}

	/*
	* Affecte l'anne de retour.
	*
	* @param		arrivalYear l'anne de retour
	*/
	public void setArrivalYear(int arrivalYear) {
		this.arrivalYear = arrivalYear;
	}

	/*
	* Renvoie une reprsentation textuelle de la
	* rservation. 
	*
	* @return		une reprsentation textuelle de la
	* 				rservation.
	*/
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append(getClass().getName());
		sb.append("@");
		sb.append(Integer.toHexString(hashCode()));
		return sb.toString();
	}
}